<?php
include("../includes/config.php");
include("../includes/db_connect.php");
include("../includes/functions.php");

require_once('../vendor/autoload.php');

$result = array();
$result["test_mode"] = 0;

if(isset($_POST["title"]) && isset($_POST['questions_array'])) {
	
	$questions = $_POST["questions_array"];
	$title = $_POST["title"];
	
	if(TEST_MODE) {
		$result["test_mode"] = 1;
		$result["status"] = 1;
		$result["error"] = "DEMO MODE : The quiz hasn't been saved. This page is for preview only.";
	} else {
		
		if($_SESSION) {
			
			$user_id = $_SESSION["USER_ID"];
			$email = $_SESSION["EMAIL"];
			$has_error = false;
			
			$unique_id = md5(uniqid($email . time(), true));
			
			// 1 -- Control the questions and answers...
			foreach($questions as $question) {
				
				if($question["title"] == "") {
					
					$has_error = true;
					break;
					
				}
							
				if(sizeof($question["answers"]) < 2) {
					
					$has_error = true;
					break;
					
				}
				
			} 
			
			if($has_error) {		
				$result["status"] = 0;
				$result["error"] = "You have some errors in your questions... Please check if they all have a title and at least two answers.";
			} 
			
			// 2 -- Test passed, we can save the quiz
			else {
				
				// Create a quiz
				$stmt = $dbh->prepare("	INSERT INTO quiz 
										SET 
										unique_id = :unique_id,
										user_id = :user_id,
										title = :title,
										created_at = NOW(),
										opened = 1
										");
									
				$stmt->bindParam(':title', $title);
				$stmt->bindParam(':unique_id', $unique_id);
				$stmt->bindParam(':user_id', $user_id);
				$stmt->execute();
				
				$quiz_id = $dbh->lastInsertId();
				
				foreach($questions as $question) {
					
					$question_title = $question["title"];
				
					// Add the questions
					$stmt = $dbh->prepare("	INSERT INTO question 
											SET 
											question = :question_title,
											quiz_id = :quiz_id,
											created_at = NOW()
											");
										
					$stmt->bindParam(':question_title', $question_title);
					$stmt->bindParam(':quiz_id', $quiz_id);
					$stmt->execute();
					
					$question_id = $dbh->lastInsertId();
					
					// Add the question's answers
					foreach($question["answers"] as $answer) {
						
						$answer_text = $answer["txt"];
						
						if($answer["good"] == "true") {
							$answer_good = 1;
						} else {
							$answer_good = 0;
						}
						
						$stmt = $dbh->prepare("	INSERT INTO question_answers 
												SET 
												answer = :answer,
												good = :good,
												quiz_id = :quiz_id,
												question_id = :question_id
												");
											
						$stmt->bindParam(':answer', $answer_text);
						$stmt->bindParam(':good', $answer_good);
						$stmt->bindParam(':quiz_id', $quiz_id);
						$stmt->bindParam(':question_id', $question_id);
						$stmt->execute();
						
					}
					
				} 
				
				$result["unique_id"] = $unique_id;
				$result["status"] = 1;
					
			}
			
		} else {
			
			$result["status"] = 0;
			$result["error"] = "Your session has expired. Please log-in again to continue...";
			
		}
	
	}
	
}

echo json_encode($result);
?>